<!DOCTYPE html> 
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Billets</title>
    <link href="CSS/billets.css" rel="stylesheet">
    <script>
        function toggleComments() {
            var commentsDiv = document.getElementById("comments");
            if (commentsDiv.style.display === "none") {
                commentsDiv.style.display = "block";
            } else {
                commentsDiv.style.display = "none";
            }
        }
    </script>
</head>
<body>
<header>
    <div class="logo"><a href="index.php">Blogies</a></div>
    <div class="nav-buttons">
        <a href="archives.php">Archives</a>
        <a href="inscription.php">Inscription</a>
        <a href="seconnecter.php">Connexion</a>
    </div>
</header>

<?php
include ("connexion.php");

if (isset($_GET['id'])) {
    $billet_id = intval($_GET['id']);


    $billet_stmt = $db->prepare("SELECT * FROM billets WHERE id = :id");
    $billet_stmt->bindValue(':id', $billet_id, PDO::PARAM_INT);
    $billet_stmt->execute();
    $billet = $billet_stmt->fetch(PDO::FETCH_ASSOC);

    if ($billet) {
        echo "<div class='container'>
                <div class='billet-header'>
                    <div class='billet-title'>{$billet['titre']}</div>
                    <div class='billet-info'>Posté le : {$billet['date_post']} | Auteur : {$billet['auteur']}</div>
                </div>
                <div class='billet-content'>
                    <p>{$billet['contenu']}</p>
                </div>";


        echo "<div class='comment-section'>
                <div class='comment-header'>
                    <h4>Commentaires :</h4>
                    <button onclick='toggleComments()'>Afficher/Masquer les commentaires</button>
                </div>
                <div id='comments' style='display: none;'>";
                
        $comment_stmt = $db->prepare("SELECT auteur, contenu, date_post FROM commentaires WHERE id_billet = :id_billet");
        $comment_stmt->bindValue(':id_billet', $billet_id, PDO::PARAM_INT);
        $comment_stmt->execute();
        $comments = $comment_stmt->fetchAll(PDO::FETCH_ASSOC);

        if (count($comments) > 0) {
            foreach ($comments as $comment) {
                echo "<div class='comment'>
                        <h5>" . htmlspecialchars($comment['auteur']) . "</h5>
                        <p><em>Posté le : " . htmlspecialchars($comment['date_post']) . "</em></p>
                        <p>" . nl2br(htmlspecialchars($comment['contenu'])) . "</p>
                      </div>";
            }
        } else {
            echo "<p>Aucun commentaire pour ce billet.</p>";
        }
        echo "</div></div>"; 


        echo "<p>Veuillez vous connecter pour écrire un commentaire.</p>
              <div class='back-button'>
                  <button type='button' onclick='window.history.back();'>Retour</button>
              </div>
              </div>"; 
    } else {
        echo "<div class='container'><p>Billet introuvable.</p></div>";
    }
} else {
    echo "<div class='container'><p>Aucun billet sélectionné.</p></div>";
}
?>
</body>
</html>
